﻿using FirebirdSql.Data.FirebirdClient;
using Serilog.Configuration;
using System;


namespace Serilog.Sinks.Firebird
{
    public static class FirebirdSinkExtensions
    {
        public static LoggerConfiguration Firebird(this LoggerSinkConfiguration loggerConfiguration, FbConnection connection, string tableName = "Logs", Func<string> prefix = null, IFormatProvider formatProvider = null)
        {
            return loggerConfiguration.Sink(new FirebirdSink(formatProvider, connection, tableName, prefix));
        }

        public static LoggerConfiguration Firebird(this LoggerSinkConfiguration loggerConfiguration, FbConnectionStringBuilder connectionStringBuilder, string tableName = "Logs", Func<string> prefix = null, IFormatProvider formatProvider = null)
        {
            return loggerConfiguration.Sink(new FirebirdSink(formatProvider, connectionStringBuilder, tableName, prefix));
        }

        public static LoggerConfiguration Firebird(this LoggerSinkConfiguration loggerConfiguration, string user, string password, string host, string database, int port, string tableName = "Logs", Func<string> prefix = null, IFormatProvider formatProvider = null)
        {
            return loggerConfiguration.Sink(new FirebirdSink(formatProvider, database, host, port, user, password, tableName, prefix));
        }

        public static LoggerConfiguration Firebird(this LoggerSinkConfiguration loggerConfiguration, string connectionString, string tableName = "Logs", Func<string> prefix = null, IFormatProvider formatProvider = null)
        {
            return loggerConfiguration.Sink(new FirebirdSink(formatProvider, connectionString, tableName, prefix));
        }
    }
}
