﻿#nullable disable
using System;
using System.Buffers;
using System.Buffers.Text;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using System.Text.Json.Serialization;


namespace ecoDMS.Library
{
    public class EcoDMSStatiCL
    {
        [JsonPropertyName("id")]
        public int Id { get; set; }
        [JsonPropertyName("name")]
        public string Name { get; set; } = String.Empty;

        public override string ToString() => Name;
    }
    public class EcoDMSRollenCL
    {
        [JsonPropertyName("name")]
        public string Name { get; set; } = String.Empty;
    }
    public class EcoDMSDokumentenartenCL
    {
        [JsonPropertyName("id")]
        public int Id { get; set; }
        [JsonPropertyName("name")]
        public string Name { get; set; }
        [JsonPropertyName("frist")]
        public EcoDMSFristenCL Fristen { get; set; }
    }
    public class EcoDMSFristenCL
    {
        [JsonPropertyName("jahre")]
        public int Jahre { get; set; }
        [JsonPropertyName("monate")]
        public int Monate { get; set; }
        [JsonPropertyName("tage")]
        public int Tage { get; set; }
    }

    public class EcoDMSApiStatistics
    {
        [JsonPropertyName("uploadCount")]
        public int UploadCount { get; set; }
        [JsonPropertyName("downloadCount")]
        public int DownloadCount { get; set; }
        [JsonPropertyName("maxCount")]
        public int MaxCount { get; set; }
    }
    public class EcoDMSOrdnerCL
    {
        [JsonPropertyName("mainFolder")]
        public bool MainFolder { get; set; }
        [JsonPropertyName("oId")]
        public string OId { get; set; } = String.Empty;
        [JsonPropertyName("foldername")]
        public string Foldername { get; set; } = String.Empty;
        [JsonPropertyName("externalKey")]
        public string ExternalKey { get; set; } = String.Empty;
        [JsonPropertyName("buzzwords")]
        public string Buzzwords { get; set; } = String.Empty;
        [JsonPropertyName("active")]
        public bool Active { get; set; }
        [JsonPropertyName("dataString")]
        public string DataString { get; set; } = String.Empty;
        [JsonIgnore]
        public string KarleyDisplayName { get; set; } = String.Empty;

        public override string ToString() => String.IsNullOrWhiteSpace(KarleyDisplayName) ? Foldername : KarleyDisplayName;
    }
    public class EcoDMSdocInfoCL
    {
        [JsonPropertyName("docId")]
        public int DocId { get; set; }
        [JsonPropertyName("clDocId")]
        public int ClDocId { get; set; }
        [JsonPropertyName("archiveName")]
        public string ArchiveName { get; set; } = String.Empty;
        [JsonPropertyName("classifyAttributes")]
        public Dictionary<string, string> ClassifyAttributes { get; set; } = new Dictionary<string, string>();
        [JsonPropertyName("editRoles")]
        public List<string> EditRoles { get; set; } = new List<string>();
        [JsonPropertyName("readRoles")]
        public List<string> ReadRoles { get; set; } = new List<string>();

    }
    public class EcoDocClassifyAttributesCL
    {
        [JsonPropertyName("docart")]
        public string Docart { get; set; } = String.Empty;

        [JsonConverter(typeof(LongToStringConverter))]
        [JsonPropertyName("docid")]
        public int Docid { get; set; }
        [JsonPropertyName("defdate")]
        public string Defdate { get; set; } = String.Empty;
        [JsonPropertyName("changeid")]
        public string Changeid { get; set; } = String.Empty;
        [JsonPropertyName("revision")]
        public string Revision { get; set; } = String.Empty;
        [JsonPropertyName("rechte")]
        public string Rechte { get; set; } = String.Empty;
        [JsonPropertyName("folder")]
        public string Folder { get; set; } = String.Empty;
        [JsonPropertyName("cdate")]
        public DateTime Cdate { get; set; }
        [JsonPropertyName("bemerkung")]
        public string Bemerkung { get; set; } = String.Empty;
        [JsonPropertyName("ctimestamp")]
        public string Ctimestamp { get; set; } = String.Empty;
        [JsonPropertyName("mainfolder")]
        public string Mainfolder { get; set; } = String.Empty;
        [JsonPropertyName("status")]
        public string Status { get; set; } = String.Empty;
    }
    public class EcoSearchFilter
    {
        [JsonPropertyName("classifyAttribut")]
        public string ClassifyAttribut { get; set; } = String.Empty;
        [JsonPropertyName("searchOperator")]
        public string SearchOperator { get; set; } = String.Empty;
        [JsonPropertyName("searchValue")]
        public string SearchValue { get; set; } = String.Empty;
    }
    public static class SuchOperator
    {
        public static string Kleiner => "<";
        public static string KleinerGleich => "<=";
        public static string Groesser => ">";
        public static string Groessergleich => ">=";
        public static string Ilike => "ilike";
        public static string Gleich => "=";

    }
    public class Dokumentenarten : List<EcoDMSDokumentenartenCL>
    {
        public EcoDMSDokumentenartenCL this[string name] => this.FirstOrDefault(x => x.Name == name);

        public Dokumentenarten(List<EcoDMSDokumentenartenCL> arten)
        {
            this.AddRange(arten);
        }
    }

    public class Klassifizierungsattribute : Dictionary<string, string>
    {
        public Klassifizierungsattribute(Dictionary<string, string> val)
        {
            foreach (var item in val)
            {
                this.Add(item.Key, item.Value);
            }
        }
        public string GetKeyByValue(string value) => this.Where(x => x.Value.Equals(value, StringComparison.OrdinalIgnoreCase)).Select(x => x.Key).FirstOrDefault();
    }
    public class Documents
    {
        [JsonPropertyName("docID")]
        public int DocID { get; set; }
        [JsonPropertyName("docInfoObject")]
        public EcoDMSdocInfoCL DocInfo { get; set; } = new EcoDMSdocInfoCL();
    }
    public class LongToStringConverter : JsonConverter<long>
    {
        public override long Read(ref Utf8JsonReader reader, Type type, JsonSerializerOptions options)
        {
            if (reader.TokenType == JsonTokenType.String)
            {
                ReadOnlySpan<byte> span = reader.HasValueSequence ? reader.ValueSequence.ToArray() : reader.ValueSpan;
                if (Utf8Parser.TryParse(span, out long number, out int bytesConsumed) && span.Length == bytesConsumed)
                {
                    return number;
                }

                if (Int64.TryParse(reader.GetString(), out number))
                {
                    return number;
                }
            }

            return reader.GetInt64();
        }

        public override void Write(Utf8JsonWriter writer, long longValue, JsonSerializerOptions options)
        {
            writer.WriteStringValue(longValue.ToString());
        }
    }
}
