﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Stammdaten.Kunden;
using WK5.Core.Models;
using WK5_Blazor.CoreExtensions;
using Microsoft.AspNetCore.Components;
using System.Threading;
using System.Windows.Forms;

namespace WK5.Desktop.Pages
{
    public partial class Index
    {
        protected override async Task OnInitializedAsync()
        {

            WK5_Blazor.Program.AppDaten = await WK5_Blazor.AppDaten.CreateAsync();
        }

        private async Task OnSaveAsync()
        {
            DataService.Busy = false;
        }

        private async Task OnCancelAsync()
        {
            DataService.Busy = false;
        }

        private Task StartKunde(string kundennr)
        {
            KarleyLibrary.Erweiterungen.StringErweiterung.OpenUrl($"https://wk5.local/Kunden/{kundennr}");
            return Task.CompletedTask;
        }

        private Task StartLieferant(int lief)
        {
            KarleyLibrary.Erweiterungen.StringErweiterung.OpenUrl($"https://wk5.local/Lieferanten/{lief}");
            return Task.CompletedTask;
        }
    }
}
