﻿using System;
using System.Collections.Generic;
using System.DirectoryServices.AccountManagement;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;

namespace WK5.Desktop
{
    public class DataService
    {
        public static Kundenkontakt Kontakt { get; set; } = new Kundenkontakt();
        public static LieferantenKontakt LiefKontakt { get; set; } = new LieferantenKontakt();
        public static bool Busy = false;
        public static NotificationForm MainForm;
        public static AppMitarbeiter Mitarbeiter { get; set; }
        public static DisplayMode Mode { get; set; }

        public static AppMitarbeiter ToAppMitarbeiter(UserPrincipal principal)
        {
            var mitarbeiter = new AppMitarbeiter
            {
                Username = principal.SamAccountName,
                PersonalNummer = Convert.ToInt32(principal.EmployeeId),
                DisplayName = principal.DisplayName,
                IsAdmin = false,
                IsBuchhaltung = false,
                IsMoneyDecisionUser = false,
            };
            return mitarbeiter;
        }
    }

    public enum DisplayMode
    {
        Kunde = 0,
        Lieferant = 1
    }
}
