﻿using FluentValidation;
using System;
using System.Linq;
using WK5.Core.Models;

namespace WK5.Core.Validators
{
    public class ZeiterfassungValidator : AbstractValidator<Zeiterfassung>
    {
        private static readonly string[] _valideTypen = new string[]
        {
            "AN", "AU", "LS", "RE", "GU", "RM", "KU"
        };
        public ZeiterfassungValidator()
        {
            RuleFor(x => x.Typ)
                .Must((typ) => IsTypValid(typ))
                .WithMessage($"Der Typ wird nicht unterstützt.")
                .When((x) => !String.IsNullOrWhiteSpace(x.Typ));

            RuleFor(x => x.Belegnummer)
                .GreaterThan(0)
                .When((x) => !x.Typ.Equals("KU"))
                .WithMessage("Es wird eine Belegnummer benötigt");

            RuleFor(x => x.Kundennummer)
                .NotEmpty()
                .NotNull()
                .WithMessage("Es wird eine Kundennummer benötigt")
                .When(x => x.Typ.Equals("KU"));
        }

        private bool IsTypValid(string typ) => _valideTypen.Contains(typ);
    }
}
