﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Verkauf.RMAS
{
    public class RmaValidator : AbstractValidator<Rma>
    {
        public decimal MaxMenge { get; set; } = 1;
        public RmaValidator()
        {
            
            
            RuleFor(x => x.LieferantId)
                .GreaterThan(0);

            RuleFor(x => x.Kundennummer)
                .NotNull()
                .NotEmpty();

            RuleFor(x => x.BelegposId)
                .GreaterThan(0);

            RuleFor(x => x.BelegChargenId)
                .GreaterThan(0);

            RuleFor(x => x.Artikelnummer)
                .NotNull()
                .NotEmpty()
                .MaximumLength(30);

            RuleFor(x => x.Seriennummer)
                .MaximumLength(60);

            RuleFor(x => x.Menge)
                .Equal(1)
                .When(x => !String.IsNullOrWhiteSpace(x.Seriennummer));

            RuleFor(x => x.Menge)
                .Must(ValidateMenge)
                .WithMessage(GetErrorMessageMenge);

            RuleFor(x => x.LieferscheinNummer)
                .GreaterThan(0);


            RuleFor(x => x.FehlerangabeKunde)
                .NotEmpty()
                .NotNull()
                .MinimumLength(10);


            RuleFor(x => x.RmaNummerLieferant)
                .MaximumLength(30);

            RuleFor(x => x.TicketNummerLieferant)
                .MaximumLength(30);

            RuleFor(x => x.TicketNummer)
                .NotEmpty()
                .NotNull()
                .MaximumLength(30)
                .ISO88591();

            RuleFor(x => x.NewZugangId)
                .GreaterThanOrEqualTo(0);

            RuleFor(x => x.GutschriftVonLieferantNummer)
                .MaximumLength(30);
        }

        private string GetErrorMessageMenge(Rma input) => $"Die Menge muss größer als 0 und kleiner oder gleich {MaxMenge} sein";
        private bool ValidateMenge(decimal menge)
        {
            return menge <= MaxMenge && menge > 0;
        }
    }
}
