﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Verkauf.Lieferscheine;

namespace WK5.Core.Validators.Verkauf.Lieferscheine
{
    public class OhneBerechnungInputValidator : AbstractValidator<OhneBerechnungInput>
    {
        public OhneBerechnungInputValidator()
        {
            RuleFor(x => x.Begründung)
                .NotNull()
                .NotEmpty()
                .MinimumLength(5)
                .MaximumLength(50);

            RuleFor(x => x.Erlöskonto)
                .GreaterThan(0);
        }
    }
}
