﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System.Linq;
using WK5.Core.Models;

namespace WK5.Core.Validators.Verkauf.Gutschriften
{
    public class GutschriftValidator : AbstractValidator<Gutschrift>
    {
        public GutschriftValidator(IValidator<Belegposition> posValidator)
        {
            RuleFor(x => x.Name1)
                .NotEmpty()
                .MaximumLength(60);

            RuleFor(x => x.Name2)
                .MaximumLength(60);

            RuleFor(x => x.Name3)
                .MaximumLength(60);

            RuleFor(x => x.Anrede)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Ansprechpartner)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.LieferbedingungId)
                .GreaterThan(0);

            RuleFor(x => x.ZahlungsbedingungId)
                .GreaterThan(0);

            RuleFor(x => x.Strasse)
                .NotEmpty()
                .MaximumLength(40);

            RuleFor(x => x.Land)
                .NotEmpty()
                .MaximumLength(2)
                .ISO88591();

            RuleFor(x => x.Postleitzahl)
                .NotEmpty()
                .MaximumLength(8);

            RuleFor(x => x.Ort)
                .NotEmpty()
                .MaximumLength(40);

            RuleFor(x => x.Notiz)
                .Must((notiz) => HasNoRtf(notiz))
                .WithMessage("Notiz ist noch im alten Format. Bitte prüfen und korrigieren.");

            RuleFor(x => x.Frachtkosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(x => x.Verpackungskosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(x => x.Versicherungskosten)
                .GreaterThanOrEqualTo(0);            

            RuleFor(x => x.Kopftext)
                .Must((kopftext) => HasNoRtf(kopftext))
                .WithMessage("Kopftext ist noch im alten Format. Bitte prüfen und korrigieren.");

            RuleFor(x => x.Fußtext)
                .Must((fußtext) => HasNoRtf(fußtext))
                .WithMessage("Fußtext ist noch im alten Format. Bitte prüfen und korrigieren.");

            RuleFor(x => x.Positionen)
                .Must((positionen) => positionen.Any())
                .WithMessage("Der Lieferschein muss mindestens über eine Position verfügen.");

            RuleFor(x => x.BestelltDurch)
              .MaximumLength(30)
              .ISO88591();

            RuleFor(x => x.Bestellnummer)
               .MaximumLength(100)
               .ISO88591();

            RuleForEach(x => x.Positionen)
                .SetValidator(posValidator);

            RuleFor(x => x.Lieferzeit)
                .Must((lieferzeit) => HasNoRtf(lieferzeit))
                .WithMessage("Lieferzeit ist noch im alten Format. Bitte prüfen und korrigieren.");
        }

        private bool HasNoRtf(string text)
        {
            return !text.StartsWith(@"{\rtf1");
        }
    }
}
