﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.PageModels.Verkauf.Aufträge;

namespace WK5.Core.Validators.Verkauf.Aufträge
{
    public class AuftragStornierenInputValidator : AbstractValidator<AuftragStornierenInput>
    {

        public AuftragStornierenInputValidator()
        {
            RuleFor(x => x.Begründung)
                .NotNull()
                .NotEmpty()
                .ISO88591();

            RuleFor(x => x.Bic)
                .BIC()
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.BankdatenErhalten);

            RuleFor(x => x.Iban)
                .IBAN()
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.BankdatenErhalten);

            RuleFor(x => x.Kontoinhaber)
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.BankdatenErhalten);

            RuleFor(x => x.TextKundenMail)
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.MailAnKunden);

            RuleFor(x => x.TextLieferantenMail)
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.MailAnLieferanten);

            RuleFor(x => x.TextBuchhaltungsMail)
                .NotEmpty()
                .NotNull()
                .ISO88591()
                .When(x => x.MailAnBuchhaltung);
        }
    }
}
