﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Text;
using System.Text.RegularExpressions;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Tools
{
    public class ZugangZahlungskonditionenValidator : AbstractValidator<Zugang>
    {
        public ZugangZahlungskonditionenValidator()
        {
            RuleFor(zugang => zugang.LIEF_A_IBAN)
                .MaximumLength(34)
                .IBAN()
                .WithName("IBAN");

            RuleFor(zugang => zugang.LIEF_A_BIC)
                .MaximumLength(11)
                .BIC()
                .WithName("BIC");

            RuleFor(zugang => zugang.InputRechnungsnummer)
                .NotEmpty()
                .MaximumLength(40)
                .WithName("Rechnungsnummer");
        }


    }
}
