﻿using FluentValidation;
using FluentValidation.Results;
using FluentValidation.Validators;
using System;
using WK5.Core.PageModels.Tools.Regalfinder;

namespace WK5.Core.Validators.Tools
{
    public class RegalFinderValidator : AbstractValidator<RegalFinderInput>
    {

        public RegalFinderValidator()
        {
            RuleFor(x => x)
                .Custom((input, context) =>
                {
                    PrüfeArtikelnummer(context, input);
                    Action<ValidationContext<RegalFinderInput>, RegalFinderInput>? zusatzprüfung = input.Modus switch
                    {
                        RegalFinderModus.AssoziationsnummerHinzufügen => PrüfeAssoziationsnummer,
                        RegalFinderModus.EanÄndern => PrüfeEan,
                        RegalFinderModus.HerstellernummerÄndern => PrüfeHerstellernummer,
                        RegalFinderModus.LagerplatzÄndern => PrüfeLagerplatz,
                        _ => null
                    };

                    if (zusatzprüfung is not null)
                    {
                        zusatzprüfung(context, input);
                    }
                });
        }


        private void PrüfeArtikelnummer(ValidationContext<RegalFinderInput> context, RegalFinderInput input)
        {
            if (String.IsNullOrWhiteSpace(input.Artikelnummer))
            {
                context.AddFailure(new ValidationFailure(nameof(input.Artikelnummer), "Bitte geben Sie eine Artikelnummer ein"));
                return;
            }
        }

        private void PrüfeLagerplatz(ValidationContext<RegalFinderInput> context, RegalFinderInput input)
        {
            if (String.IsNullOrWhiteSpace(input.Lagerplatz))
            {
                context.AddFailure(new ValidationFailure(nameof(input.Lagerplatz), "Bitte wählen Sie einen Lagerplatz aus"));
            }
        }

        private void PrüfeEan(ValidationContext<RegalFinderInput> context, RegalFinderInput input)
        {
            if (String.IsNullOrWhiteSpace(input.Ean))
            {
                context.AddFailure(new ValidationFailure(nameof(input.Ean), "Bitte geben Sie eine EAN ein"));
            }
        }

        private void PrüfeHerstellernummer(ValidationContext<RegalFinderInput> context, RegalFinderInput input)
        {
            if (String.IsNullOrWhiteSpace(input.Herstellernummer))
            {
                context.AddFailure(new ValidationFailure(nameof(input.Herstellernummer), "Bitte geben Sie eine Herstellernummer ein"));
            }
        }

        private void PrüfeAssoziationsnummer(ValidationContext<RegalFinderInput> context, RegalFinderInput input)
        {
            if (String.IsNullOrWhiteSpace(input.AlternativArtikelnummer))
            {
                context.AddFailure(new ValidationFailure(nameof(input.AlternativArtikelnummer), "Bitte geben Sie eine Assoziationsnummer ein"));
            }
        }
    }
}
