﻿using FluentValidation;
using FluentValidation.Results;
using System.Collections.Generic;
using WK5.Core.PageModels.Tools;

namespace WK5.Core.Validators.Tools
{
    public class RechnungsPrüfungInputValidator : AbstractValidator<List<RechnungsPrüfungInput>>
    {
        public RechnungsPrüfungInputValidator()
        {
            RuleForEach(x => x)
                .Custom((zugang, context) =>
                {
                    if (zugang.Exportieren && zugang.Bemerkung.Length > 60)
                    {
                        context.AddFailure(new ValidationFailure(nameof(zugang.Bemerkung), "Die Bemerkung darf nicht länger als 60 Zeichen sein."));
                    }
                });

        }
    }
}
