﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter.Statistik;

namespace WK5.Core.Validators.Statistik.Verkauf
{
    public class TopArtikelNachLieferantFilterValidator : AbstractValidator<TopArtikelNachLieferantFilter>
    {
        public TopArtikelNachLieferantFilterValidator()
        {
            RuleFor(x => x.LieferantId)
                .GreaterThan(0);

            RuleFor(x => x.AnzahlMaxErgebnisse)
                .LessThanOrEqualTo(100);

            RuleFor(x => x.Suchbegriff)
                .NotEmpty()
                .WithMessage(x => $"Die ID {x.LieferantId} ist keinem Lieferanten zugeordnet.");

            RuleFor(x => x.Zeitraum.Von)
                .Must((x, y) => x.Zeitraum.Von < x.Zeitraum.Bis)
                .WithMessage("Von kann nicht größer sein als Bis");
        }
    }
}
