﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter.Statistik;

namespace WK5.Core.Validators.Statistik.Verkauf
{
    public class MitarbeiterStatistikFilterValidator : AbstractValidator<MitarbeiterStatistikFilter>
    {
        public MitarbeiterStatistikFilterValidator()
        {
            RuleFor(x => x.MitarbeiterId)
                .GreaterThan(0)
                .WithMessage("Bitte wählen Sie einen Mitarbeiter aus.");

            RuleFor(x => x.Typ)
                .Must(x => x is "AN" or "AU" or "LS" or "RE" or "GU" or "BE");

            RuleFor(x => x.From)
                .Must((filter, von) => von.Date < filter.To.Date)
                .WithMessage("Von kann nicht größer sein als bis.");
        }
    }
}
