﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5.Core.Validators.Stammdaten.Lieferanten
{
    public class LieferantenPartnerInputValidator : AbstractValidator<LieferantenPartnerInput>
    {
        public LieferantenPartnerInputValidator()
        {
            RuleFor(x => x.Lieferantennummer)
                .GreaterThanOrEqualTo(70000);

            RuleFor(x => x.Name)
                .MaximumLength(60)
                .NotEmpty()
                .ISO88591();

            RuleFor(x => x.Bereich)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(x => x.Telefon)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Handy)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Fax)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Email)
                .MaximumLength(60)
                .EmailAddress()
                .ISO88591();

            RuleFor(x => x.Adresstext)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Anrede)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(x => x.Notiz)
                .MaximumLength(80)
                .ISO88591();

            RuleFor(x => x)
                .Custom((x, context) =>
                {
                    if (String.IsNullOrWhiteSpace(x.Email) && String.IsNullOrWhiteSpace(x.Telefon))
                    {
                        context.AddFailure("Lieferanten Ansprechpartner muss eine Email oder Telefonnummer enthalten.");
                    }
                });
        }
    }
}
