﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5.Core.Validators.Stammdaten.Lieferanten
{
    public class LieferantenInputValidator : AbstractValidator<LieferantenInput>
    {
        public LieferantenInputValidator(IValidator<LieferantenAnschriftInput> anschriftValidator)
        {

            RuleFor(x => x.Lieferantennummer)
                .GreaterThanOrEqualTo(0);

            RuleFor(x => x.Partner)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Name1)
                .NotEmpty()
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Name2)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Strasse)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Ort)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Strasse)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Land)
                .MaximumLength(3)
                .ISO88591();

            RuleFor(x => x.Postleitzahl)
                .MaximumLength(8)
                .ISO88591();

            RuleFor(x => x.Telefon1)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Telefon2)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Fax)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(x => x.Email)
                .MaximumLength(60)
                .EmailAddress()
                .ISO88591();

            RuleFor(x => x.Homepage)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.UnsereKundennummer)
                .MaximumLength(20)
                .ISO88591();

            RuleFor(x => x.Suchbegriff)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(x => x.LieferbedingungId)
                .InclusiveBetween(1, 12);

            RuleFor(x => x.Suchbegriff)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(x => x.UstId)
                .MaximumLength(20)
                .UstId()
                .ISO88591();

            RuleFor(x => x.Waehrung)
                .MaximumLength(3)
                .ISO88591();

            RuleFor(x => x.Bankkonto)
                .MaximumLength(14)
                .ISO88591();

            RuleFor(x => x.IBAN)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Bankleitzahl)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(x => x.BIC)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(x => x.Kontoinhaber)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Bankname)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Selektionsmerkmal1)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(x => x.Selektionsmerkmal2)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(x => x.Selektionsmerkmal3)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(x => x.ShopUsername)
                .ISO88591();

            RuleFor(x => x.ShopPasswort)
                .ISO88591();

            RuleFor(x => x.UnsereKundennummer)
                .Must((lief, kundennummer) => lief.Gesperrt ? true : !String.IsNullOrWhiteSpace(lief.UnsereKundennummer))
                .WithMessage("'{PropertyName}' darf nicht leer sein.");

            RuleForEach(x => x.Anschriften)
                .SetValidator(anschriftValidator);
        }
    }
}
