﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5.Core.Validators.Stammdaten.Lieferanten
{
    public class LieferantenAnschriftInputValidator : AbstractValidator<LieferantenAnschriftInput>
    {
        public LieferantenAnschriftInputValidator()
        {
            RuleFor(x => x.Lieferantennummer)
                .GreaterThanOrEqualTo(70000);

            RuleFor(x => x.Name1)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Name2)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Name3)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(x => x.Ansprechpartner)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Strasse)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Land)
                .MaximumLength(3)
                .ISO88591();

            RuleFor(x => x.Postleitzahl)
                .MaximumLength(8)
                .ISO88591();

            RuleFor(x => x.Ort)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Telefon)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Fax)
                .MaximumLength(30)
                .Phone()
                .ISO88591();

            RuleFor(x => x.Email)
                .MaximumLength(60)
                .ISO88591()
                .EmailAddress();

            RuleFor(x => x.IBAN)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.BIC)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(x => x.Bankname)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.Kontoinhaber)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(x => x.AdressFunktion)
                .MaximumLength(100)
                .ISO88591();
        }
    }
}
