﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class RechnungsanschriftInputValidator : AbstractValidator<RechnungsanschriftInput>
    {
        public RechnungsanschriftInputValidator()
        {
            RuleFor(rech => rech.Firma)
                .MaximumLength(60)
                .NotEmpty()
                .ISO88591();

            RuleFor(rech => rech.Name2)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(rech => rech.Name3)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(rech => rech.Straße)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(rech => rech.Land)
                .MaximumLength(2)
                .NotEmpty()
                .ISO88591();

            RuleFor(rech => rech.Postleitzahl)
                .MaximumLength(8)
                .NotEmpty()
                .ISO88591();

            RuleFor(rech => rech.Ort)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(rech => rech.Telefon)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(rech => rech.Fax)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(rech => rech.Email)
                .MaximumLength(60)
                .EmailAddress(FluentValidation.Validators.EmailValidationMode.AspNetCoreCompatible)
                .ISO88591();

            RuleFor(rech => rech.Partner)
                .MaximumLength(40)
                .ISO88591();
        }
    }
}
