﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class LieferanschriftInputValidator : AbstractValidator<LieferanschriftInput>
    {
        public LieferanschriftInputValidator()
        {
            RuleFor(lief => lief.Firma)
                .MaximumLength(60)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Name2)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(lief => lief.Name3)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(lief => lief.Straße)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Land)
                .MaximumLength(2)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Postleitzahl)
                .MaximumLength(8)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Ort)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Telefon)
                .MaximumLength(30)
                .NotEmpty()
                .ISO88591();

            RuleFor(lief => lief.Fax)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(lief => lief.Email)
                .MaximumLength(60)
                .EmailAddress(FluentValidation.Validators.EmailValidationMode.AspNetCoreCompatible)
                .ISO88591();

            RuleFor(lief => lief.Partner)
                .MaximumLength(40)
                .ISO88591();



        }
    }
}
