﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class LastschriftKonditionenInputValidator : AbstractValidator<LastschriftKonditionenInput>
    {

        public LastschriftKonditionenInputValidator()
        {
            RuleFor(x => x.Ausstellungsdatum)
                .Must((datum) => datum != default)
                .WithMessage("Bitte geben Sie das Austellungsdatum des Mandats an.");

            RuleFor(x => x.IBAN)
                .NotNull()
                .NotEmpty()
                .IBAN();

            RuleFor(x => x.BIC)
                .NotNull()
                .NotEmpty()
                .BIC();
        }
    }
}
