﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class KundenrabattInputValidator : AbstractValidator<KundenrabattInput>
    {
        public KundenrabattInputValidator(IValidator<StaffelpreisCollection> staffelValidator)
        {
            RuleFor(kusa => kusa.Kundennummer)
                .NotEmpty()
                .MaximumLength(8)
                .ISO88591();

            RuleFor(kusa => kusa.Artikelnummer)
                .NotEmpty()
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kusa => kusa.Kundenartikelnummer)
                .MaximumLength(30)
                .ISO88591();



            RuleFor(kusa => kusa.StaffelMenge1)
                .GreaterThanOrEqualTo(0);

            RuleFor(kusa => kusa.StaffelMenge2)
                .GreaterThanOrEqualTo(0);

            RuleFor(kusa => kusa.StaffelMenge3)
                .GreaterThanOrEqualTo(0);

            RuleFor(kusa => kusa.StaffelMenge4)
                .GreaterThanOrEqualTo(0);

            RuleFor(kusa => kusa.StaffelRabatt1)
                .InclusiveBetween(0, 100);

            RuleFor(kusa => kusa.StaffelRabatt2)
                .InclusiveBetween(0, 100);

            RuleFor(kusa => kusa.StaffelRabatt3)
                .InclusiveBetween(0, 100);

            RuleFor(kusa => kusa.StaffelRabatt4)
                .InclusiveBetween(0, 100);

            RuleFor(kusa => kusa.Rabatt1)
                .InclusiveBetween(0, 100);


            RuleFor(kusa => kusa.Staffelpreise)
                .SetValidator(staffelValidator);
        }
    }
}

