﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.Models;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class KundenkontaktValidator : AbstractValidator<Kundenkontakt>
    {
        public KundenkontaktValidator()
        {
            RuleFor(x => x.KUKO_A_KUNDNR)
                .MaximumLength(8)
                .ISO88591();

            RuleFor(x => x.KUKO_A_PARTNER)
                .MaximumLength(100)
                .ISO88591();

            RuleFor(x => x.KUKO_A_NOTIZ)
                .MaximumLength(2000);

            RuleFor(x => x.KUKO_WK5_A_BETREFF)
                .MaximumLength(100)
                .ISO88591();

            RuleFor(x => x.KUKO_D_DATE)
                .Must(date => date != default)
                .WithMessage("Bitte geben Sie ein Datum an!");
        }
    }
}
