﻿using FluentValidation;
using FluentValidation.Results;
using KarleyLibrary.Erweiterungen;
using System;
using System.Linq;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class KundeInputValidator : AbstractValidator<KundeInput>
    {
        public KundeInputValidator(IValidator<LieferanschriftInput> liefValidator, IValidator<RechnungsanschriftInput> rechValidator)
        {
            RuleFor(kund => kund.Firma)
                .NotEmpty()
                .MaximumLength(60);

            RuleFor(kund => kund.Name2)
                .MaximumLength(60);

            RuleFor(kund => kund.Name3)
                .MaximumLength(60);

            RuleFor(kund => kund.Strasse)
                .MaximumLength(40)
                .NotEmpty();

            RuleFor(kund => kund.Ort)
                .MaximumLength(40)
                .NotEmpty();

            RuleFor(kund => kund.Land)
                .MaximumLength(2)
                .ISO88591();

            RuleFor(kund => kund.Postleitzahl)
                .MaximumLength(8)
                .NotEmpty();

            RuleFor(kund => kund.Anrede)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(kund => kund.Telefon1)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kund => kund.Telefon2)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kund => kund.Fax)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kund => kund.Handy)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kund => kund.Email)
                .MaximumLength(60)
                .EmailAddress(FluentValidation.Validators.EmailValidationMode.AspNetCoreCompatible)
                .ISO88591();

            RuleFor(kund => kund.Homepage)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(kund => kund.Suchbegriff)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(kund => kund.LieferbedingungId)
                .GreaterThanOrEqualTo(1);

            RuleFor(kund => kund.ZahlungsbedingungId)
                .GreaterThanOrEqualTo(1);

            RuleFor(kund => kund.VertreterId)
                .GreaterThanOrEqualTo(0);

            RuleFor(kund => kund.KundengruppeId)
                .GreaterThanOrEqualTo(0);

            RuleFor(kund => kund.PreislisteId)
                .GreaterThanOrEqualTo(0)
                .WithName("Preisliste");

            RuleFor(kund => kund.Kreditlimit)
                .GreaterThanOrEqualTo(0);

            RuleFor(kund => kund.Debitorennummer)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.UstId)
                .MaximumLength(30)
                .ISO88591()
                .UstId();

            RuleFor(kund => kund.Steuernummer)
                .MaximumLength(20)
                .ISO88591();

            RuleFor(kund => kund.LieferantNummer)
                .MaximumLength(20)
                .ISO88591();

            RuleFor(kund => kund.Gln)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(kund => kund.Handelsregisternummer)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Amtsgericht)
                .MaximumLength(255)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal1)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal2)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal3)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal4)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal5)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.Selektionsmerkmal6)
                .MaximumLength(10)
                .ISO88591();

            RuleFor(kund => kund.IBAN)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(kund => kund.BIC)
                .MaximumLength(15)
                .ISO88591();

            RuleFor(kund => kund.Notiz)
                .MaximumLength(1000);

            RuleFor(kund => kund.IBAN)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(kund => kund.UstIdFirma)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(kund => kund.UstIdStrasse)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(kund => kund.UstIdPostleitzahl)
                .MaximumLength(8)
                .ISO88591();

            RuleFor(kund => kund.UstIdOrt)
                .MaximumLength(40)
                .ISO88591();

            RuleFor(kund => kund.Mandatsreferenz)
                .MaximumLength(100)
                .ISO88591();

            RuleFor(kund => kund.EmpfohlenVon)
                .MaximumLength(100)
                .ISO88591();

            RuleFor(kunde => kunde.Sperrvermerk)
                .MaximumLength(255)
                .ISO88591();

            RuleForEach(kund => kund.Lieferanschriften)
                .SetValidator(liefValidator);

            RuleForEach(kund => kund.Rechnungsanschriften)
                .SetValidator(rechValidator);


            RuleFor(kund => kund)
                .Custom((kund, context) =>
                {
                    if (String.IsNullOrWhiteSpace(kund.Email) && String.IsNullOrWhiteSpace(kund.Telefon1))
                    {
                        context.AddFailure(new ValidationFailure(nameof(kund), "Es muss eine Email oder eine Telefonnummer angegeben werden."));
                    }
                });



        }
    }
}
