﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Validators.Stammdaten.Kunden
{
    public class AnsprechpartnerInputValidator : AbstractValidator<AnsprechpartnerInput>
    {
        public AnsprechpartnerInputValidator()
        {
            RuleFor(part => part.Vorname)
                .MaximumLength(60)
                .ISO88591();

            RuleFor(part => part.Nachname)
                .MaximumLength(60)
                .NotEmpty()
                .ISO88591();

            RuleFor(part => part.Bereich)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(part => part.Anrede)
                .MaximumLength(40)
                .NotEmpty()
                .ISO88591();

            RuleFor(part => part.Telefon)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(part => part.Mobil)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(part => part.Fax)
                .MaximumLength(30)
                .ISO88591();

            RuleFor(part => part.Email)
                .MaximumLength(60)
                .EmailAddress()
                .ISO88591();

            RuleFor(part => part)
                .Custom((part, context) =>
                {
                    if (String.IsNullOrWhiteSpace(part.Email) && String.IsNullOrWhiteSpace(part.Telefon))
                    {
                        context.AddFailure("Ansprechpartner muss eine Email oder Telefonnummer enthalten.");
                    }
                });
        }
    }
}
