﻿using FluentValidation;
using WK5.Core.Models;

namespace WK5.Core.Validators.Stammdaten.Artikeldaten
{
    public class LieferantenartikelValidator : AbstractValidator<Lieferantenartikel>
    {
        public LieferantenartikelValidator(IValidator<StaffelpreisCollection> staffelValidator)
        {
            RuleFor(lief => lief.ARLI_A_BESTELLNR)
                .MaximumLength(30)
                .NotEmpty();

            //RuleFor(lief => lief.ARLI_A_BEZ1)
            //    .MaximumLength(60)
            //    .NotEmpty();

            //RuleFor(lief => lief.ARLI_A_BEZ2)
            //    .MaximumLength(60);

            //RuleFor(lief => lief.ARLI_A_BEZ3)
            //    .MaximumLength(60);

            //RuleFor(lief => lief.ARLI_A_BEZ4)
            //    .MaximumLength(60);

            //RuleFor(lief => lief.ARLI_A_BEZ5)
            //    .MaximumLength(60);

            RuleFor(x => x.ARLI_N_PREIS)
                .GreaterThan(0);

            RuleFor(lief => lief.ARLI_A_ARTIKELNR)
                .MaximumLength(30)
                .NotEmpty();

            RuleFor(lief => lief.ARLI_N_PREIS)
                .GreaterThan(0);

            RuleFor(lief => lief.ARLI_N_RABATT)
                .InclusiveBetween(0, 100);

            RuleFor(lief => lief.ARLI_N_RABATT2)
                .InclusiveBetween(0, 100);

            RuleFor(lief => lief.ARLI_N_MINDESTABNAHME)
                .GreaterThan(0);

            RuleFor(lief => lief.ARLI_N_VERSANDKOST)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.ARLI_N_VERPACKKOST)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.ARLI_N_TEUERUNG)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.ARLI_N_SONSTKOST)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.ARLI_A_WAEHRUNG)
                .MaximumLength(5);

            RuleFor(lief => lief.ARLI_N_KURS)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.ARLI_N_WAEHRUNGSPREIS)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.WK5_ARLI_N_LIEFBESTAND)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Staffelpreise)
                .SetValidator(staffelValidator);
        }
    }
}
