﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Stammdaten.Artikeldaten
{
    public class BundleArtikelValidator : AbstractValidator<Artikel>
    {
        public static string Prefix(string template) => $"Stücklistenartikel {template}";
        public BundleArtikelValidator()
        {

            RuleFor(stl => stl.Artikelnummer)
                .NotEmpty();

            RuleFor(stl => stl.BUNDLE_N_MENGE)
                .GreaterThan(0);
        }
    }
}
