﻿using FluentValidation;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Artikeldaten;

namespace WK5.Core.Validators.Stammdaten.Artikeldaten
{
    public class ArtikelLieferantenInputValidator : AbstractValidator<LieferantenArtikelInput>
    {
        public static string Prefix(string template) => $"Lieferantenartikel {template}";

        public ArtikelLieferantenInputValidator(IValidator<StaffelpreisCollection> staffelValidator)
        {
            RuleFor(lief => lief.Bestellnummer)
                .MaximumLength(30)
                .NotEmpty();

            RuleFor(lief => lief.Beschreibung1)
                .MaximumLength(60)
                .NotEmpty();

            RuleFor(lief => lief.Beschreibung2)
                .MaximumLength(60);

            RuleFor(lief => lief.Beschreibung3)
                .MaximumLength(60);

            RuleFor(lief => lief.Beschreibung4)
                .MaximumLength(60);

            RuleFor(lief => lief.Beschreibung5)
                .MaximumLength(60);


            RuleFor(lief => lief.Artikelnummer)
                .MaximumLength(30)
                .NotEmpty();

            RuleFor(lief => lief.Preis)
                .GreaterThan(0);

            RuleFor(lief => lief.Rabatt)
                .InclusiveBetween(0, 100);

            RuleFor(lief => lief.Rabatt2)
                .InclusiveBetween(0, 100);

            RuleFor(lief => lief.Mindestabnahme)
                .GreaterThan(0);

            RuleFor(lief => lief.Versandkosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Verpackungskosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Teuerung)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Sonstiges)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Währung)
                .MaximumLength(5);

            RuleFor(lief => lief.Kurs)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.PreisWährung)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Lieferantenbestand)
                .GreaterThanOrEqualTo(0);

            RuleFor(lief => lief.Staffelpreise)
                .SetValidator(staffelValidator);
        }
    }
}
