﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Stammdaten.Artikeldaten
{
    public class ArtikelAngebotValidator : AbstractValidator<ArtikelAngebot>
    {
        // Sobald irgendwas nicht zutrifft fliegen wir raus.... beim Test also von oben nach Unten prüfen wenn eine Regel nichts macht.
        // Niemals Async in fluent nutzen, funktioniert bei ASP.NET nicht.
        public ArtikelAngebotValidator()
        {
            RuleFor(an => an.ARAN_A_ARTINR)
                .NotEmpty()
                .ISO88591();

            RuleFor(an => an.ARAN_D_ENDE)
                .Must((an, dt) => dt == default || dt > DateTime.Now)
                .WithMessage($"Das Ende des Angebots muss in der Zukunft liegen");
            
            RuleFor(tmpName => tmpName.ARAN_N_PREIS)
                .GreaterThan(0);
        }
    }
}
