﻿using FluentValidation;
using System;
using System.Data;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Artikeldaten;
using System.Linq;

namespace WK5.Core.Validators
{
    public class StaffelpreisCollectionValidator : AbstractValidator<StaffelpreisCollection>
    {
        public StaffelpreisCollectionValidator()
        {
            RuleFor(x => x)
                .Custom((collection, context) =>
                {
                    for (int i = 0; i < collection.Count(); i++)
                    {
                        Staffelpreis? preis = collection.Get(i);
                        if (preis is not null)
                        {
                            if (!(preis.Rabatt <= 0 ? true : preis.Rabatt > 0 && preis.Menge > 0))
                            {
                                context.AddFailure($"Wenn Staffelrabatt {i + 1} > 0 ist, muss Staffelmenge {i + 1} auch > 0 sein.");
                            }

                            if (!(preis.Menge <= 0 ? true : preis.Menge > 0 && preis.Rabatt > 0))
                            {
                                context.AddFailure($"Wenn Staffelmenge {i + 1} > 0 ist, muss Staffelrabatt {i + 1} auch > 0 sein.");
                            }

                            if (!(preis.Menge > 1))
                            {
                                context.AddFailure($"Staffelmenge {i + 1} muss > 1 sein.");
                            }

                            if (!(preis.Menge <= 0 ? true : collection.Where(x => x.Menge == preis.Menge).Count() <= 1))
                            {
                                context.AddFailure($"Staffelmenge {i + 1} darf nicht eine schon vorhandene Menge haben.");
                            }

                            if (preis.Rabatt <= 0)
                            {
                                context.AddFailure($"Staffelrabatt {i + 1} darf nicht kleiner 0% sein.");
                            }

                            if (preis.Rabatt > 75)
                            {
                                context.AddFailure($"Staffelrabatt {i + 1} darf nicht größer 75% sein.");
                            }
                        }
                    }
                });
        }
    }
}
