﻿using FluentValidation;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class ZugangSeriennummerInputValidator : AbstractValidator<ZugangSeriennummerInput>
    {
        public ZugangSeriennummerInputValidator()
        {
            RuleFor(x => x.Seriennummer)
                .NotNull()
                .NotEmpty()
                .WithMessage("Bitte geben Sie eine Seriennummer an");

            RuleFor(x => x.Seriennummer)
                .MaximumLength(60)
                .WithMessage("Die Seriennummer darf nicht länger als 60 Zeichen sein");

            RuleFor(x => x.Seriennummer)
                .Must((sn) => IsValidSeriennummer(sn))
                .WithMessage("Bitte geben Sie eine gültige Seriennummer ein. Sollte der Lieferant keine Seriennummer genannt haben, so ist diese nachzufragen, oder ggf die Seriennummer-Verwaltung für den Artikel zu deaktivieren.");
        }

        private bool IsValidSeriennummer(string seriennummer)
        {
            if(seriennummer.StartsWith("ohne", System.StringComparison.OrdinalIgnoreCase))
            {
                return false;
            }

            if(seriennummer.StartsWith("---", System.StringComparison.OrdinalIgnoreCase))
            {
                return false;
            }

            return true;
        }
    }
}
