﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Lager
{
    public class WareEinlagernArtikelValidator : AbstractValidator<WareEinlagernArtikel>
    {
        public WareEinlagernArtikelValidator()
        {
            RuleFor(x => x.Lagerplatz)
                .NotNull()
                .NotEmpty();

            RuleFor(x => x.Lagerplatz)
                .Must((x) =>
                {
                    var lagerplatz = Task.Run(() => Lagerplatz.GetLagerAsync(x)).GetAwaiter().GetResult();
                    return lagerplatz is not null;
                })
                .WithMessage((x) => $"Der Lagerplatz {x.Lagerplatz} konnte nicht gefunden werdne");
        }
    }
}
