﻿using FluentValidation;
using System.Linq;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class PositionBuchenInputValidator : AbstractValidator<PositionBuchenInput>
    {
        public PositionBuchenInputValidator(IValidator<ZugangSeriennummerInput> seriennummerValidator)
        {
            RuleFor(pos => pos.Menge)
                .GreaterThan(0);

            RuleFor(pos => pos.Preis)
                .GreaterThanOrEqualTo(0);

            RuleForEach(pos => pos.Seriennummern)
                .SetValidator(seriennummerValidator);

            RuleFor(pos => pos.Seriennummern)
                .Must((arr) => KeineDoppeltenSeriennummern(arr))
                .WithMessage("Der Zugang kann nicht zweimal die gleiche Seriennummer enthalten");
        }

        private bool KeineDoppeltenSeriennummern(ZugangSeriennummerInput[] seriennummern)
        {
            return !seriennummern.GroupBy(x => x.Seriennummer)
                .Where(x => x.Count() > 1)
                .Any();
        }
    }
}
