﻿using FluentValidation;
using System;
using System.IO;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class LieferscheinBuchenInputValidator : AbstractValidator<LieferscheinBuchenInput>
    {
        public LieferscheinBuchenInputValidator(IValidator<PositionBuchenInput> posValidator)
        {
            RuleFor(zugang => zugang.LieferscheinNummer)
                .NotNull()
                .NotEmpty()
                .WithMessage("Bitte geben Sie eine Lieferscheinnummer an.");

            RuleFor(x => x.LieferscheinNummer)
                .MaximumLength(40);

            RuleFor(zugang => zugang.LieferscheinDatum)
                .Must((datum) => datum.Date > DateTime.Today.Date.AddDays(-20))
                .WithMessage("Das Lieferscheindatum muss innerhalb der letzten 20 Tage liegen");

            RuleForEach(zugang => zugang.Positionen)
                .SetValidator(posValidator);

            RuleFor(zugang => zugang.Positionen)
                .Must((positionen) => positionen.Count > 0)
                .WithMessage("Der Zugang muss mindestens eine Position enthalten");

        }
    }
}
