﻿using FluentValidation;
using FluentValidation.Results;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class LagerabwertungInputValidator : AbstractValidator<LagerabwertungInput>
    {
        public LagerabwertungInputValidator()
        {
            RuleFor(x => x.Menge)
                .GreaterThan(0);

            RuleFor(x => x.Seriennummer)
                .MaximumLength(60);

            RuleFor(x => x)
                .Custom((input, context) =>
                {
                    if (input.Menge > input.MaxMenge)
                    {
                        context.AddFailure(new ValidationFailure(nameof(input.Menge), $"Die Menge darf nicht größer als {input.MaxMenge} sein"));
                    }
                });

            RuleFor(x => x)
                .Custom((input, context) =>
                {
                    if (input.Preis > input.MaxPreis)
                    {
                        context.AddFailure(new ValidationFailure(nameof(input.Preis), $"Der Preis darf nicht größer als {input.MaxPreis} sein"));
                    }
                });
        }
    }
}
