﻿using FluentValidation;
using WK5.Core.Models.Lager;
using WK5.Core.Models.Versand;

namespace WK5.Core.Validators.Lager
{
    public class DirektlieferungFortführenInputValidator : AbstractValidator<DirektlieferungFortführenInput>
    {
        public DirektlieferungFortführenInputValidator(IValidator<PaketInput> paketValidator)
        {
            RuleForEach(x => x.Pakete)
                .SetValidator(paketValidator)
                .When(x => x.Versender is not Courier.OHNETRACKINGNUMMER);
        }
    }
}
