﻿using FluentValidation;
using FluentValidation.Results;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class ChargenUmbuchenInputValidator : AbstractValidator<ChargenUmbuchenInput>
    {
        public ChargenUmbuchenInputValidator()
        {
            RuleFor(x => x.NeueArtikelnummer)
                .NotEmpty()
                .NotNull();

            RuleFor(x => x.AlteArtikelnummer)
                .NotEmpty()
                .NotNull();

            RuleFor(x => x.Charge)
                .GreaterThan(0);

            RuleFor(x => x.Menge)
                .GreaterThan(0);

            RuleFor(x => x.Seriennummer)
                .MaximumLength(60);

            RuleFor(x => x)
                .Custom((input, context) =>
                {
                    if (input.Menge > input.MaxMenge)
                    {
                        context.AddFailure(new ValidationFailure(nameof(input.Menge), $"Die Menge darf nicht größer als {input.MaxMenge} sein"));
                    }
                });
        }
    }
}
