﻿using FluentValidation;
using FluentValidation.Results;
using WK5.Core.Models.Lager;

namespace WK5.Core.Validators.Lager
{
    public class AbgangBuchenInputValidator : AbstractValidator<AbgangBuchenInput>
    {
        public AbgangBuchenInputValidator()
        {
            RuleFor(abgang => abgang.Menge)
                .GreaterThan(0);

            RuleFor(abgang => abgang.Kostenstelle)
                .GreaterThan(0)
                .WithMessage("Bitte wählen Sie eine Kostenstelle aus");

            RuleFor(abgang => abgang.Notiz)
                .MaximumLength(60);

            RuleFor(abgang => abgang.Seriennummer)
                .MaximumLength(60);

            RuleFor(abgang => abgang)
                .Custom((abgang, context) =>
                {
                    if (abgang.Menge > abgang.MaxMenge)
                    {
                        context.AddFailure(new ValidationFailure(nameof(abgang.Menge), $"Die Menge darf nicht größer als {abgang.MaxMenge} sein"));
                    }
                });
        }
    }
}
