﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using System;
using System.Linq;
using WK5.Core.Models;

namespace WK5.Core.Validators.Bestellungen
{
    public class BestellungValidator : AbstractValidator<Bestellung>
    {

        public BestellungValidator(IValidator<Bestellposition> posValidator)
        {

            RuleFor(bestellung => bestellung.BEST_A_ANGEBOTNR)
                .MaximumLength(30);

            RuleFor(bestellung => bestellung.BEST_A_PARTNER)
                .MaximumLength(40);

            RuleFor(bestellung => bestellung.BEST_A_BESTAET_NR_LIEF)
                .MaximumLength(30);

            RuleFor(bestellung => bestellung.Versandkosten)
                .GreaterThanOrEqualTo(0);                

            RuleFor(bestellung => bestellung)
                .Must((bestellung) => bestellung.Bestellnummer is 0 ? bestellung.BEST_D_LIEFTERMIN.Date > DateTime.Today.Date : true)
                .WithMessage("Liefertermin muss in der Zukunft liegen");            

            RuleFor(bestellung => bestellung.Positionen)
                .Must((pos) => pos.Any())
                .WithMessage("Fügen Sie mindestens eine Position zur Bestellung hinzu.");

            RuleForEach(bestellung => bestellung.Positionen)
                .SetValidator(posValidator);

            RuleFor(bestellung => bestellung.Verpackungskosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(bestellung => bestellung.Versicherungskosten)
                .GreaterThanOrEqualTo(0);

            RuleFor(bestellung => bestellung.BEST_N_AB_NR)
                .GreaterThan(0)
                .WithMessage("Eine Direktlieferung erfordert die Eingabe einer Auftragsnummer")
                .When(bestellung => bestellung.Direktlieferung);
        }


    }
}
