﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.PageModels.Einkauf.Bestellungen;

namespace WK5.Core.Validators.Bestellungen
{
    public class BestellungErledigtInputValidator : AbstractValidator<BestellungErledigtInput>
    {
        public BestellungErledigtInputValidator()
        {
            RuleFor(x => x.ErledigtBegründung)
                .MinimumLength(5)
                .MaximumLength(50)
                .ISO88591();
        }
    }
}
