﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Bestellungen
{
    public class BestellungAbrufValidator : AbstractValidator<BestellungAbruf>
    {
        public Bestellung? Input { get; set; }
        public BestellungAbrufValidator()
        {
            RuleForEach(x => x.Positionen)
                .Must(pos => CheckPositionen(pos, Input))
                .WithMessage((abruf, pos) =>
                {
                    var bestellpos = Input.Positionen.First(x => x.BEPO_N_POSID == pos.PosId);
                    return $"Für den Artikel {pos.Artikelnummer} können nur noch {bestellpos.BEPO_N_MENGE - bestellpos.BEPO_N_LIEFERMENGE} Stück abgerufen werden";
                })
                .Must(x => x.Menge > 0)
                .WithMessage((abruf, pos) => $"Für den Artikel {pos.Artikelnummer} muss eine Abrufmenge angegeben werden!");

            RuleFor(x => x.Positionen)
                .Must(x => x.Count > 0)
                .WithMessage("Der Abruf muss mindestens über eine Position verfügen");
        }


        private bool CheckPositionen(BestellungAbrufPos pos, Bestellung input)
        {
            var bestellpos = input.Positionen.First(x => x.BEPO_N_POSID == pos.PosId);

            return (bestellpos.BEPO_N_MENGE - bestellpos.BEPO_N_LIEFERMENGE) >= pos.Menge;
        }
    }
}
