﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.Models;

namespace WK5.Core.Validators.Bestellungen
{
    public class BestellpositionValidator : AbstractValidator<Bestellposition>
    {
        public BestellpositionValidator()
        {
            RuleFor(pos => pos.BEPO_A_BESTELLNUMMER)
                .MaximumLength(30);

            RuleFor(pos => pos.BEPO_A_BEZ1)
                .MaximumLength(70);

            RuleFor(pos => pos.BEPO_A_BEZ2)
                .MaximumLength(70);

            RuleFor(pos => pos.BEPO_A_BEZ3)
                .MaximumLength(70);

            RuleFor(pos => pos.BEPO_A_BEZ4)
                .MaximumLength(70);

            RuleFor(pos => pos.BEPO_A_BEZ5)
                .MaximumLength(70);                

            RuleFor(pos => pos.BEPO_N_MENGE)
                .GreaterThan(0)
                .When(pos => !pos.BEPO_A_ARTIKELNR.Equals("TEXT"));

            RuleFor(pos => pos.BEPO_N_PREIS)
                .GreaterThanOrEqualTo(0);

            RuleFor(pos => pos.BEPO_N_RABATTPROZ)
                .InclusiveBetween(0, 100);

            RuleFor(pos => pos.BEPO_N_RABATTPROZ2)
                .InclusiveBetween(0, 100);

        }
    }
}
