﻿using FluentValidation;
using System;
using WK5.Core.Models.Bestellungen;

namespace WK5.Core.Validators.Bestellungen
{
    public class AuftragBestellenPositionValidator : AbstractValidator<AuftragBestellenPosition>
    {
        public AuftragBestellenPositionValidator()
        {
            RuleFor(pos => pos.Bestellnummer)
                .MaximumLength(30);

            RuleFor(pos => pos.Bezeichnung1)
                .MaximumLength(70);

            RuleFor(pos => pos.Bezeichnung2)
                .MaximumLength(70);

            RuleFor(pos => pos.Bezeichnung3)
                .MaximumLength(70);

            RuleFor(pos => pos.Bezeichnung4)
                .MaximumLength(70);

            RuleFor(pos => pos.Bezeichnung5)
                .MaximumLength(70);

            RuleFor(pos => pos.Rabatt1)
                .InclusiveBetween(0, 100);

            RuleFor(pos => pos.Rabatt2)
                .InclusiveBetween(0, 100);

            RuleFor(pos => pos.Artikelnummer)
                .MaximumLength(30);

            RuleFor(pos => pos.Lieferdatum)
                .Must(LieferterminInZukunft)
                .WithMessage(pos => $"Der Liefertermin für den Artikel {pos.Artikelnummer} kann muss in der Zukunft liegen.");
        }

        private bool LieferterminInZukunft(DateTime liefertermin) => liefertermin > DateTime.Now;
    }
}
