﻿using FluentValidation;
using System.Collections.Generic;
using WK5.Core.Models.Bestellungen;

namespace WK5.Core.Validators.Bestellungen
{
    public class AuftragBestellenControllerValidator : AbstractValidator<AuftragBestellenController>
    {

        public AuftragBestellenControllerValidator(IValidator<AuftragBestellenBestellung> bestellungValidator)
        {
            RuleFor(controller => controller.Bestellungen)
                .Must(MindestensEineBestellung)
                .WithMessage("Es muss mindestens eine Bestellung vorhanden sein.");

            RuleForEach(controller => controller.Bestellungen)
                .SetValidator(bestellungValidator);

            // Denkbar wären hier weitere Vergleiche von Bestellung und Artikeln
        }

        private bool MindestensEineBestellung(List<AuftragBestellenBestellung> list) => list.Count > 0;
    }
}
