﻿using FluentValidation;
using System;
using WK5.Core.Models.Bestellungen;

namespace WK5.Core.Validators.Bestellungen
{
    public class AuftragBestellenBestellungValidator : AbstractValidator<AuftragBestellenBestellung>
    {

        public AuftragBestellenBestellungValidator(IValidator<AuftragBestellenPosition> posValidator)
        {

            RuleFor(bestellung => bestellung.Liefertermin)
                .Must(LieferterminInZukunft)
                .WithMessage("Bitte geben Sie einen zukünftigen Liefertermin an.");

            RuleForEach(bestellung => bestellung.Positionen)
                .SetValidator(posValidator);
        }


        /// <summary>
        /// Prüft, ob der Liefertermin auch in der Zukunft liegt.
        /// </summary>
        /// <param name="liefertermin"></param>
        /// <returns></returns>
        private bool LieferterminInZukunft(DateTime liefertermin) => liefertermin > DateTime.Now;



    }
}
