﻿using FluentValidation;
using KarleyLibrary.Erweiterungen;
using WK5.Core.Models;

namespace WK5.Core.Validators.Admin.Mitarbeiterverwaltung
{
    public class PersonalValidator : AbstractValidator<Personal>
    {
        public PersonalValidator()
        {
            RuleFor(x => x.PERS_A_VORNAME)
                .NotEmpty()
                .NotNull()
                .MaximumLength(30)
                .ISO88591();

            RuleFor(x => x.PERS_A_NAME)
                .NotEmpty()
                .NotNull()
                .MaximumLength(30)
                .ISO88591();
        }
    }
}
