﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Admin.Hilfsdaten
{
    public class ArtikelOptionValueValidator : AbstractValidator<ArtikelOptionValue>
    {
        public ArtikelOptionValueValidator()
        {
            RuleFor(x => x.Name)
                .NotEmpty()
                .NotNull()
                .MaximumLength(30);

            RuleFor(x => x.SortOrder)
                .GreaterThanOrEqualTo(0);
        }
    }
}
