﻿using FluentValidation;
using FluentValidation.Validators;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Validators.Admin.Hilfsdaten
{
    public class ArtikelOptionValidator : AbstractValidator<ArtikelOption>
    {
        public ArtikelOptionValidator(IValidator<ArtikelOptionValue> optionValueValidator)
        {
            RuleFor(x => x.Name)
                .NotNull()
                .NotEmpty()
                .MaximumLength(40);

            RuleFor(x => x.Typ)
                .Must((typ) => CheckTyp(typ))
                .WithMessage((x) => $"Der Typ {x.Typ} ist unzulässig.");

            RuleFor(x => x.MinValue)
                .GreaterThanOrEqualTo(0)
                .When(x => x.Typ is "number");

            RuleFor(x => x.MaxValue)
                .GreaterThanOrEqualTo(0)
                .When(x => x.Typ is "number");

            RuleFor(x => x.SortOrder)
                .GreaterThanOrEqualTo(0);

            RuleForEach(x => x.OptionValues)
                .SetValidator(optionValueValidator)
                .When(x => x.Typ is "select");
        }

        private bool CheckTyp(string typ)
        {
            string[] typen = new string[]
            {
                "text",
                "textarea",
                "number",
                "select"
            };

            return typen.Contains(typ);
        }
    }
}
