﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Tools
{
    public class LeasingCalculator
    {
        public decimal Nettowert { get; set; }
        public decimal Provision { get; set; }

        protected decimal[,] _faktoren;
        public LeasingCalculator(decimal nettowert, decimal provision)
        {
            _faktoren = new decimal[2, 5];
            _faktoren[0, 0] = 5.95m;
            _faktoren[0, 1] = 4.56m;
            _faktoren[0, 2] = 3.72m;
            _faktoren[0, 3] = 3.17m;
            _faktoren[0, 4] = 2.47m;
            _faktoren[1, 0] = 5.89m;
            _faktoren[1, 1] = 4.50m;
            _faktoren[1, 2] = 3.67m;
            _faktoren[1, 3] = 3.11m;
            _faktoren[1, 4] = 2.42m;

            Nettowert = nettowert;
            Provision = provision;

        }

        public IEnumerable<(string intervall, decimal preis)> Berechne(LeasingCalculatorArt art)
        {
            int faktorIndex = 0;

            if (Nettowert > 10000)
            {
                faktorIndex = 1;
            }
            string[] intervalle = Array.Empty<string>();
            decimal provi = 1 + (Provision / 100);
            decimal preis = 0;
            switch (art)
            {
                case LeasingCalculatorArt.EDV:
                    intervalle = new string[]
                    {
                        "18 Monate",
                        "24 Monate",
                        "30 Monate",
                        "A (36 Monate)",
                        "A (48 Monate)"
                    };
                    for (int i = 0; i < intervalle.Length; i++)
                    {
                        preis = Runden(Nettowert * _faktoren[faktorIndex, i] / 100 * provi);
                        yield return (intervalle[i], preis);
                    }
                    break;
                case LeasingCalculatorArt.DigitaleDrucksysteme:
                    intervalle = new string[]
                    {
                        "24 Monate",
                        "30 Monate",
                        "36 Monate",
                        "48 Monate"
                    };

                    for (int i = 0; i < intervalle.Length; i++)
                    {
                        preis = Runden(Nettowert * _faktoren[faktorIndex, i + 1] / 100 * provi);
                        yield return (intervalle[i], preis);
                    }
                    break;
                case LeasingCalculatorArt.Kasse:
                    intervalle = new string[]
                    {
                        "30 Monate",
                        "36 Monate",
                        "48 Monate"
                    };
                    for (int i = 0; i < intervalle.Length; i++)
                    {
                        preis = Runden(Nettowert * _faktoren[faktorIndex, i + 2] / 100 * provi);
                        yield return (intervalle[i], preis);
                    }
                    break;
                default:
                    break;
            }
        }

        private decimal Runden(decimal wert)
        {
            decimal stellen = wert * 100 % 100;
            if (stellen > 0)
            {
                if (Nettowert is < 2000 and >= 1000)
                {
                    stellen = stellen > 10 ? stellen > 20 ? stellen > 40 ? stellen > 60 ? stellen > 80 ? 99 : 80 : 60 : 40 : 20 : 0;
                }
                else if (Nettowert is > 2000 and <= 5000)
                {
                    stellen = stellen > 10 ? stellen > 50 ? 99 : 50 : 0;
                }
                else
                {
                    stellen = 99;
                }

                if (stellen is 99)
                {
                    decimal temp = Math.Round(wert, 0);
                    return temp;
                }
                else
                {
                    decimal temp = Math.Round(wert, 0) + stellen / 100;
                    return temp;
                }
            }
            else
            {
                return wert;
            }

        }
    }

    public enum LeasingCalculatorArt
    {
        EDV,
        DigitaleDrucksysteme,
        Kasse
    }
}
