﻿using System.Text;
using WK5.Core.Models;
using WK5.Core.PageModels.Verkauf.Angebote;
using WK5.Core.PageModels.Verkauf.Aufträge;
using WK5.Core.PageModels.Verkauf.Lieferscheine;

namespace WK5.Core.Tools.Gewichtsberechner
{
    /// <summary>
    /// Stellt eine KundenAnschrift für einen Beleg dar.
    /// <para>
    /// Der Unterschied zwischen dieser Klasse und <see cref="Lieferanschrift"/> ist der, dass berücksichtigt wird, ob der Beleg überhaupt eine separate Lieferanschrift hat.
    /// </para>
    /// </summary>
    public class KundenAnschrift
    {
        public string Strasse { get; set; }
        public string Postleitzahl { get; set; }
        public string Name { get; set; }
        public string Ort { get; set; }
        public string Land { get; set; }

        public KundenAnschrift(Beleg beleg)
        {
            Strasse = beleg.Strasse;
            Ort = beleg.Ort;
            Postleitzahl = beleg.Postleitzahl;
            Name = SetzeName(beleg.Name1, beleg.Name2, beleg.Name3);
            Land = beleg.Land;
        }
        public KundenAnschrift(Lieferanschrift lieferanschrift)
        {
            Strasse = lieferanschrift.KULA_A_STRASSE;
            Ort = lieferanschrift.KULA_A_ORT;
            Postleitzahl = lieferanschrift.KULA_A_PLZ;
            Name = SetzeName(lieferanschrift.KULA_A_NAME1, lieferanschrift.KULA_A_NAME2, lieferanschrift.KULA_A_NAME3);
            Land = lieferanschrift.KULA_A_LAND;
        }

        public KundenAnschrift(string strasse, string ort, string plz, string name, string land)
        {
            Strasse = strasse;
            Ort = ort;
            Postleitzahl = plz;
            Name = SetzeName(name, null, null);
            Land = land;
        }

        private string SetzeName(string? name1, string? name2, string? name3)
        {
            StringBuilder sb = new StringBuilder();
            if (name1 != null)
            {
                sb.Append(name1);
            }

            int length = sb.Length;
            if (length > 0)
            {
                sb.Append(' ');
            }

            if (name2 != null)
            {
                sb.Append(name2);
            }

            if (sb.Length > length)
            {
                sb.Append(' ');
            }

            if (name3 != null)
            {
                sb.Append(name3);
            }

            return sb.ToString().Trim();
        }
        /// <summary>
        /// Liefert die Anschrift als formatierten HTML String zurück, welcher direkt in einem address Tag eingebunden werden kann.
        /// </summary>
        /// <returns></returns>
        public string GetFormattedHtmlAnschrift()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("<p>");
            sb.AppendLine(Name);
            sb.AppendLine("<br />");
            sb.AppendLine(Strasse);
            sb.AppendLine("<br />");
            sb.AppendLine($"{Postleitzahl} {Ort}");
            sb.AppendLine("<br />");
            sb.AppendLine(Land);
            sb.AppendLine("</p>");

            return sb.ToString();
        }
    }
}
