﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.TodoService
{
    /// <summary>
    /// Stellt ein TODO für den TodoWk5 Service dar.
    /// </summary>
    public class Todo
    {
        public int TODO_N_NR { get; set; }
        public int TODO_N_TYP { get; set; }
        public string TODO_A_PARAM { get; set; } = "";
        public string TODO_A_BELE_TYP { get; set; } = "";
        public string TODO_A_BELE_NR { get; set; } = "";
        public bool TODO_L_ERLEDIGT { get; set; }
        public bool TODO_L_ERFOLGREICH { get; set; }
        public DateTime TODO_D_WANN { get; set; }
        public DateTime TODO_TIMESTAMP { get; set; }

        /// <summary>
        /// Liefert alle noch nicht abgeschlossenen TODOs
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public static async IAsyncEnumerable<Todo> GetTodosAsync(FbController2 fbController)
        {
            var data = new DataTable();

            // Der Server kann ggf. nicht erreichbar sein.
            try
            {
                data = await fbController.SelectDataAsync("SELECT * FROM WK5_TODO WHERE TODO_L_ERLEDIGT = 'N' ORDER BY TODO_N_NR DESC");
            }
            catch (Exception)
            {

            }

            foreach (DataRow todoRow in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Todo(), todoRow);
            }
        }

        /// <summary>
        /// Setzt ein Todo auf erledigt.
        /// </summary>
        public async Task CompleteTodoAsync()
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ERFOLGREICH", TODO_L_ERFOLGREICH ? 'Y' : 'N');
            fbController.AddParameter("@TODO_NR", TODO_N_NR);
            await fbController.QueryAsync("UPDATE WK5_TODO SET TODO_L_ERLEDIGT = 'Y', TODO_L_ERFOLGREICH = @ERFOLGREICH, TODO_TIMESTAMP = CURRENT_TIMESTAMP WHERE TODO_N_NR = @TODO_NR");
        }
        /// <summary>
        /// Wandelt das TODO Objekt in ein <see cref="ITodoAbgearbeitet"/> um.
        /// </summary>
        /// <returns></returns>
        public ITodoAbgearbeitet ToAbgearbeitetTodo()
        {
            if (String.IsNullOrWhiteSpace(TODO_A_BELE_TYP) && String.IsNullOrWhiteSpace(TODO_A_BELE_NR))
            {
                return new TodoParamAbgearbeitet
                {
                    TODO_N_TYP = TODO_N_TYP,
                    TODO_A_PARAM = TODO_A_PARAM
                };
            }
            else
            {
                return new TodoAbgearbeitet
                {
                    TODO_A_BELE_A_TYP = TODO_A_BELE_TYP,
                    TODO_A_BELE_NR = TODO_A_BELE_NR,
                    TODO_N_TYP = TODO_N_TYP
                };
            }
        }
        /// <summary>
        /// Wandelt <see cref="TODO_N_TYP"/> in den entsprechenden <see cref="TodoType"/> um
        /// </summary>
        /// <returns></returns>
        public TodoType GetTodoType()
        {
            return (TodoType)TODO_N_TYP;
        }
    }
}
